package odata.msgraph.client.beta.entity.collection.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.util.Map;

import odata.msgraph.client.beta.entity.PrivilegedApproval;
import odata.msgraph.client.beta.entity.request.PrivilegedApprovalRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

public class PrivilegedApprovalCollectionRequest extends CollectionPageEntityRequest<PrivilegedApproval, PrivilegedApprovalRequest>{

    protected ContextPath contextPath;

    public PrivilegedApprovalCollectionRequest(ContextPath contextPath) {
        super(contextPath, PrivilegedApproval.class, cp -> new PrivilegedApprovalRequest(cp), SchemaInfo.INSTANCE);
        this.contextPath = contextPath;
    }



    @Function(name = "myRequests")
    @JsonIgnore
    public CollectionPageNonEntityRequest<PrivilegedApproval> myRequests() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.myRequests"), PrivilegedApproval.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

}
