package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.PrivilegedAccess;
import odata.msgraph.client.beta.entity.request.GovernanceResourceRequest;
import odata.msgraph.client.beta.entity.request.GovernanceRoleAssignmentRequest;
import odata.msgraph.client.beta.entity.request.GovernanceRoleAssignmentRequestRequest;
import odata.msgraph.client.beta.entity.request.GovernanceRoleDefinitionRequest;
import odata.msgraph.client.beta.entity.request.GovernanceRoleSettingRequest;
import odata.msgraph.client.beta.entity.request.PrivilegedAccessRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

public class PrivilegedAccessCollectionRequest extends CollectionPageEntityRequest<PrivilegedAccess, PrivilegedAccessRequest>{

    protected ContextPath contextPath;

    public PrivilegedAccessCollectionRequest(ContextPath contextPath) {
        super(contextPath, PrivilegedAccess.class, cp -> new PrivilegedAccessRequest(cp), SchemaInfo.INSTANCE);
        this.contextPath = contextPath;
    }

    public GovernanceResourceCollectionRequest resources() {
        return new GovernanceResourceCollectionRequest(contextPath.addSegment("resources"));
    }

    public GovernanceResourceRequest resources(String id) {
        return new GovernanceResourceRequest(contextPath.addSegment("resources").addKeys(new NameValue(id.toString())));
    }

    public GovernanceRoleDefinitionCollectionRequest roleDefinitions() {
        return new GovernanceRoleDefinitionCollectionRequest(contextPath.addSegment("roleDefinitions"));
    }

    public GovernanceRoleDefinitionRequest roleDefinitions(String id) {
        return new GovernanceRoleDefinitionRequest(contextPath.addSegment("roleDefinitions").addKeys(new NameValue(id.toString())));
    }

    public GovernanceRoleAssignmentCollectionRequest roleAssignments() {
        return new GovernanceRoleAssignmentCollectionRequest(contextPath.addSegment("roleAssignments"));
    }

    public GovernanceRoleAssignmentRequest roleAssignments(String id) {
        return new GovernanceRoleAssignmentRequest(contextPath.addSegment("roleAssignments").addKeys(new NameValue(id.toString())));
    }

    public GovernanceRoleAssignmentRequestCollectionRequest roleAssignmentRequests() {
        return new GovernanceRoleAssignmentRequestCollectionRequest(contextPath.addSegment("roleAssignmentRequests"));
    }

    public GovernanceRoleAssignmentRequestRequest roleAssignmentRequests(String id) {
        return new GovernanceRoleAssignmentRequestRequest(contextPath.addSegment("roleAssignmentRequests").addKeys(new NameValue(id.toString())));
    }

    public GovernanceRoleSettingCollectionRequest roleSettings() {
        return new GovernanceRoleSettingCollectionRequest(contextPath.addSegment("roleSettings"));
    }

    public GovernanceRoleSettingRequest roleSettings(String id) {
        return new GovernanceRoleSettingRequest(contextPath.addSegment("roleSettings").addKeys(new NameValue(id.toString())));
    }

}
