package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.PrinterShare;
import odata.msgraph.client.beta.entity.request.PrintIdentityRequest;
import odata.msgraph.client.beta.entity.request.PrintUserIdentityRequest;
import odata.msgraph.client.beta.entity.request.PrinterShareRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

public class PrinterShareCollectionRequest extends CollectionPageEntityRequest<PrinterShare, PrinterShareRequest>{

    protected ContextPath contextPath;

    public PrinterShareCollectionRequest(ContextPath contextPath) {
        super(contextPath, PrinterShare.class, cp -> new PrinterShareRequest(cp), SchemaInfo.INSTANCE);
        this.contextPath = contextPath;
    }


    public PrintUserIdentityCollectionRequest allowedUsers() {
        return new PrintUserIdentityCollectionRequest(contextPath.addSegment("allowedUsers"));
    }

    public PrintUserIdentityRequest allowedUsers(String id) {
        return new PrintUserIdentityRequest(contextPath.addSegment("allowedUsers").addKeys(new NameValue(id.toString())));
    }

    public PrintIdentityCollectionRequest allowedGroups() {
        return new PrintIdentityCollectionRequest(contextPath.addSegment("allowedGroups"));
    }

    public PrintIdentityRequest allowedGroups(String id) {
        return new PrintIdentityRequest(contextPath.addSegment("allowedGroups").addKeys(new NameValue(id.toString())));
    }

}
