package odata.msgraph.client.beta.entity.collection.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.util.Map;

import odata.msgraph.client.beta.complex.PrintCertificateSigningRequest;
import odata.msgraph.client.beta.entity.Printer;
import odata.msgraph.client.beta.entity.request.PrintConnectorRequest;
import odata.msgraph.client.beta.entity.request.PrintIdentityRequest;
import odata.msgraph.client.beta.entity.request.PrintTaskTriggerRequest;
import odata.msgraph.client.beta.entity.request.PrintUserIdentityRequest;
import odata.msgraph.client.beta.entity.request.PrinterRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

public class PrinterCollectionRequest extends CollectionPageEntityRequest<Printer, PrinterRequest>{

    protected ContextPath contextPath;

    public PrinterCollectionRequest(ContextPath contextPath) {
        super(contextPath, Printer.class, cp -> new PrinterRequest(cp), SchemaInfo.INSTANCE);
        this.contextPath = contextPath;
    }

    public PrintUserIdentityCollectionRequest allowedUsers() {
        return new PrintUserIdentityCollectionRequest(contextPath.addSegment("allowedUsers"));
    }

    public PrintUserIdentityRequest allowedUsers(String id) {
        return new PrintUserIdentityRequest(contextPath.addSegment("allowedUsers").addKeys(new NameValue(id.toString())));
    }

    public PrintIdentityCollectionRequest allowedGroups() {
        return new PrintIdentityCollectionRequest(contextPath.addSegment("allowedGroups"));
    }

    public PrintIdentityRequest allowedGroups(String id) {
        return new PrintIdentityRequest(contextPath.addSegment("allowedGroups").addKeys(new NameValue(id.toString())));
    }


    public PrintConnectorCollectionRequest connectors() {
        return new PrintConnectorCollectionRequest(contextPath.addSegment("connectors"));
    }

    public PrintConnectorRequest connectors(String id) {
        return new PrintConnectorRequest(contextPath.addSegment("connectors").addKeys(new NameValue(id.toString())));
    }

    public PrintTaskTriggerCollectionRequest taskTriggers() {
        return new PrintTaskTriggerCollectionRequest(contextPath.addSegment("taskTriggers"));
    }

    public PrintTaskTriggerRequest taskTriggers(String id) {
        return new PrintTaskTriggerRequest(contextPath.addSegment("taskTriggers").addKeys(new NameValue(id.toString())));
    }

    @Action(name = "create")
    @JsonIgnore
    public ActionRequestNoReturn create(String displayName, String manufacturer, String model, String physicalDeviceId, Boolean hasPhysicalDevice, PrintCertificateSigningRequest certificateSigningRequest, String connectorId) {
        Preconditions.checkNotNull(displayName, "displayName cannot be null");
        Preconditions.checkNotNull(manufacturer, "manufacturer cannot be null");
        Preconditions.checkNotNull(model, "model cannot be null");
        Preconditions.checkNotNull(certificateSigningRequest, "certificateSigningRequest cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("displayName", "Edm.String", Checks.checkIsAscii(displayName))
            .put("manufacturer", "Edm.String", Checks.checkIsAscii(manufacturer))
            .put("model", "Edm.String", Checks.checkIsAscii(model))
            .put("physicalDeviceId", "Edm.String", Checks.checkIsAscii(physicalDeviceId))
            .put("hasPhysicalDevice", "Edm.Boolean", hasPhysicalDevice)
            .put("certificateSigningRequest", "microsoft.graph.printCertificateSigningRequest", certificateSigningRequest)
            .put("connectorId", "Edm.String", Checks.checkIsAscii(connectorId))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.create"), _parameters);
    }

}
