package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.PrintTaskDefinition;
import odata.msgraph.client.beta.entity.request.PrintTaskDefinitionRequest;
import odata.msgraph.client.beta.entity.request.PrintTaskRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

public class PrintTaskDefinitionCollectionRequest extends CollectionPageEntityRequest<PrintTaskDefinition, PrintTaskDefinitionRequest>{

    protected ContextPath contextPath;

    public PrintTaskDefinitionCollectionRequest(ContextPath contextPath) {
        super(contextPath, PrintTaskDefinition.class, cp -> new PrintTaskDefinitionRequest(cp), SchemaInfo.INSTANCE);
        this.contextPath = contextPath;
    }

    public PrintTaskCollectionRequest tasks() {
        return new PrintTaskCollectionRequest(contextPath.addSegment("tasks"));
    }

    public PrintTaskRequest tasks(String id) {
        return new PrintTaskRequest(contextPath.addSegment("tasks").addKeys(new NameValue(id.toString())));
    }

}
