package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.PrintService;
import odata.msgraph.client.beta.entity.request.PrintServiceEndpointRequest;
import odata.msgraph.client.beta.entity.request.PrintServiceRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

public class PrintServiceCollectionRequest extends CollectionPageEntityRequest<PrintService, PrintServiceRequest>{

    protected ContextPath contextPath;

    public PrintServiceCollectionRequest(ContextPath contextPath) {
        super(contextPath, PrintService.class, cp -> new PrintServiceRequest(cp), SchemaInfo.INSTANCE);
        this.contextPath = contextPath;
    }

    public PrintServiceEndpointCollectionRequest endpoints() {
        return new PrintServiceEndpointCollectionRequest(contextPath.addSegment("endpoints"));
    }

    public PrintServiceEndpointRequest endpoints(String id) {
        return new PrintServiceEndpointRequest(contextPath.addSegment("endpoints").addKeys(new NameValue(id.toString())));
    }

}
