package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.PrintJob;
import odata.msgraph.client.beta.entity.request.PrintDocumentRequest;
import odata.msgraph.client.beta.entity.request.PrintJobRequest;
import odata.msgraph.client.beta.entity.request.PrintTaskRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

public class PrintJobCollectionRequest extends CollectionPageEntityRequest<PrintJob, PrintJobRequest>{

    protected ContextPath contextPath;

    public PrintJobCollectionRequest(ContextPath contextPath) {
        super(contextPath, PrintJob.class, cp -> new PrintJobRequest(cp), SchemaInfo.INSTANCE);
        this.contextPath = contextPath;
    }

    public PrintDocumentCollectionRequest documents() {
        return new PrintDocumentCollectionRequest(contextPath.addSegment("documents"));
    }

    public PrintDocumentRequest documents(String id) {
        return new PrintDocumentRequest(contextPath.addSegment("documents").addKeys(new NameValue(id.toString())));
    }

    public PrintTaskCollectionRequest tasks() {
        return new PrintTaskCollectionRequest(contextPath.addSegment("tasks"));
    }

    public PrintTaskRequest tasks(String id) {
        return new PrintTaskRequest(contextPath.addSegment("tasks").addKeys(new NameValue(id.toString())));
    }

}
