package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.Post;
import odata.msgraph.client.beta.entity.request.AttachmentRequest;
import odata.msgraph.client.beta.entity.request.ExtensionRequest;
import odata.msgraph.client.beta.entity.request.MentionRequest;
import odata.msgraph.client.beta.entity.request.MultiValueLegacyExtendedPropertyRequest;
import odata.msgraph.client.beta.entity.request.PostRequest;
import odata.msgraph.client.beta.entity.request.SingleValueLegacyExtendedPropertyRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

public class PostCollectionRequest extends CollectionPageEntityRequest<Post, PostRequest>{

    protected ContextPath contextPath;

    public PostCollectionRequest(ContextPath contextPath) {
        super(contextPath, Post.class, cp -> new PostRequest(cp), SchemaInfo.INSTANCE);
        this.contextPath = contextPath;
    }


    public SingleValueLegacyExtendedPropertyCollectionRequest singleValueExtendedProperties() {
        return new SingleValueLegacyExtendedPropertyCollectionRequest(contextPath.addSegment("singleValueExtendedProperties"));
    }

    public SingleValueLegacyExtendedPropertyRequest singleValueExtendedProperties(String id) {
        return new SingleValueLegacyExtendedPropertyRequest(contextPath.addSegment("singleValueExtendedProperties").addKeys(new NameValue(id.toString())));
    }

    public MultiValueLegacyExtendedPropertyCollectionRequest multiValueExtendedProperties() {
        return new MultiValueLegacyExtendedPropertyCollectionRequest(contextPath.addSegment("multiValueExtendedProperties"));
    }

    public MultiValueLegacyExtendedPropertyRequest multiValueExtendedProperties(String id) {
        return new MultiValueLegacyExtendedPropertyRequest(contextPath.addSegment("multiValueExtendedProperties").addKeys(new NameValue(id.toString())));
    }

    public ExtensionCollectionRequest extensions() {
        return new ExtensionCollectionRequest(contextPath.addSegment("extensions"));
    }

    public ExtensionRequest extensions(String id) {
        return new ExtensionRequest(contextPath.addSegment("extensions").addKeys(new NameValue(id.toString())));
    }

    public AttachmentCollectionRequest attachments() {
        return new AttachmentCollectionRequest(contextPath.addSegment("attachments"));
    }

    public AttachmentRequest attachments(String id) {
        return new AttachmentRequest(contextPath.addSegment("attachments").addKeys(new NameValue(id.toString())));
    }

    public MentionCollectionRequest mentions() {
        return new MentionCollectionRequest(contextPath.addSegment("mentions"));
    }

    public MentionRequest mentions(String id) {
        return new MentionRequest(contextPath.addSegment("mentions").addKeys(new NameValue(id.toString())));
    }

}
