package odata.msgraph.client.beta.entity.collection.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.util.List;
import java.util.Map;

import odata.msgraph.client.beta.entity.PolicySet;
import odata.msgraph.client.beta.entity.request.PolicySetAssignmentRequest;
import odata.msgraph.client.beta.entity.request.PolicySetItemRequest;
import odata.msgraph.client.beta.entity.request.PolicySetRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

public class PolicySetCollectionRequest extends CollectionPageEntityRequest<PolicySet, PolicySetRequest>{

    protected ContextPath contextPath;

    public PolicySetCollectionRequest(ContextPath contextPath) {
        super(contextPath, PolicySet.class, cp -> new PolicySetRequest(cp), SchemaInfo.INSTANCE);
        this.contextPath = contextPath;
    }

    public PolicySetAssignmentCollectionRequest assignments() {
        return new PolicySetAssignmentCollectionRequest(contextPath.addSegment("assignments"));
    }

    public PolicySetAssignmentRequest assignments(String id) {
        return new PolicySetAssignmentRequest(contextPath.addSegment("assignments").addKeys(new NameValue(id.toString())));
    }

    public PolicySetItemCollectionRequest items() {
        return new PolicySetItemCollectionRequest(contextPath.addSegment("items"));
    }

    public PolicySetItemRequest items(String id) {
        return new PolicySetItemRequest(contextPath.addSegment("items").addKeys(new NameValue(id.toString())));
    }

    @Action(name = "getPolicySets")
    @JsonIgnore
    public CollectionPageNonEntityRequest<PolicySet> getPolicySets(List<String> policySetIds) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("policySetIds", "Collection(Edm.String)", Checks.checkIsAscii(policySetIds))
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getPolicySets"), PolicySet.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

}
