package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.PlannerPlan;
import odata.msgraph.client.beta.entity.request.PlannerBucketRequest;
import odata.msgraph.client.beta.entity.request.PlannerPlanRequest;
import odata.msgraph.client.beta.entity.request.PlannerTaskRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

public class PlannerPlanCollectionRequest extends CollectionPageEntityRequest<PlannerPlan, PlannerPlanRequest>{

    protected ContextPath contextPath;

    public PlannerPlanCollectionRequest(ContextPath contextPath) {
        super(contextPath, PlannerPlan.class, cp -> new PlannerPlanRequest(cp), SchemaInfo.INSTANCE);
        this.contextPath = contextPath;
    }

    public PlannerTaskCollectionRequest tasks() {
        return new PlannerTaskCollectionRequest(contextPath.addSegment("tasks"));
    }

    public PlannerTaskRequest tasks(String id) {
        return new PlannerTaskRequest(contextPath.addSegment("tasks").addKeys(new NameValue(id.toString())));
    }

    public PlannerBucketCollectionRequest buckets() {
        return new PlannerBucketCollectionRequest(contextPath.addSegment("buckets"));
    }

    public PlannerBucketRequest buckets(String id) {
        return new PlannerBucketRequest(contextPath.addSegment("buckets").addKeys(new NameValue(id.toString())));
    }


}
