package odata.msgraph.client.beta.entity.collection.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.util.Map;

import odata.msgraph.client.beta.entity.PlannerDelta;
import odata.msgraph.client.beta.entity.request.PlannerDeltaRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

public class PlannerDeltaCollectionRequest extends CollectionPageEntityRequest<PlannerDelta, PlannerDeltaRequest>{

    protected ContextPath contextPath;

    public PlannerDeltaCollectionRequest(ContextPath contextPath) {
        super(contextPath, PlannerDelta.class, cp -> new PlannerDeltaRequest(cp), SchemaInfo.INSTANCE);
        this.contextPath = contextPath;
    }

    @Function(name = "delta")
    @JsonIgnore
    public CollectionPageNonEntityRequest<PlannerDelta> delta() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.delta"), PlannerDelta.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

}
