package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.PlannerBucket;
import odata.msgraph.client.beta.entity.request.PlannerBucketRequest;
import odata.msgraph.client.beta.entity.request.PlannerTaskRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

public class PlannerBucketCollectionRequest extends CollectionPageEntityRequest<PlannerBucket, PlannerBucketRequest>{

    protected ContextPath contextPath;

    public PlannerBucketCollectionRequest(ContextPath contextPath) {
        super(contextPath, PlannerBucket.class, cp -> new PlannerBucketRequest(cp), SchemaInfo.INSTANCE);
        this.contextPath = contextPath;
    }

    public PlannerTaskCollectionRequest tasks() {
        return new PlannerTaskCollectionRequest(contextPath.addSegment("tasks"));
    }

    public PlannerTaskRequest tasks(String id) {
        return new PlannerTaskRequest(contextPath.addSegment("tasks").addKeys(new NameValue(id.toString())));
    }

}
