package odata.msgraph.client.beta.entity.collection.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.util.List;
import java.util.Map;

import odata.msgraph.client.beta.complex.InvitationParticipantInfo;
import odata.msgraph.client.beta.entity.InviteParticipantsOperation;
import odata.msgraph.client.beta.entity.MuteParticipantsOperation;
import odata.msgraph.client.beta.entity.Participant;
import odata.msgraph.client.beta.entity.request.ParticipantRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

public class ParticipantCollectionRequest extends CollectionPageEntityRequest<Participant, ParticipantRequest>{

    protected ContextPath contextPath;

    public ParticipantCollectionRequest(ContextPath contextPath) {
        super(contextPath, Participant.class, cp -> new ParticipantRequest(cp), SchemaInfo.INSTANCE);
        this.contextPath = contextPath;
    }

    @Action(name = "invite")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<InviteParticipantsOperation> invite(List<InvitationParticipantInfo> participants, String clientContext) {
        Preconditions.checkNotNull(participants, "participants cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("participants", "Collection(microsoft.graph.invitationParticipantInfo)", participants)
            .put("clientContext", "Edm.String", Checks.checkIsAscii(clientContext))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<InviteParticipantsOperation>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.invite"), InviteParticipantsOperation.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Action(name = "muteAll")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<MuteParticipantsOperation> muteAll(List<String> participants, String clientContext) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("participants", "Collection(Edm.String)", Checks.checkIsAscii(participants))
            .put("clientContext", "Edm.String", Checks.checkIsAscii(clientContext))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<MuteParticipantsOperation>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.muteAll"), MuteParticipantsOperation.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

}
