package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.OutlookTaskGroup;
import odata.msgraph.client.beta.entity.request.OutlookTaskFolderRequest;
import odata.msgraph.client.beta.entity.request.OutlookTaskGroupRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

public class OutlookTaskGroupCollectionRequest extends CollectionPageEntityRequest<OutlookTaskGroup, OutlookTaskGroupRequest>{

    protected ContextPath contextPath;

    public OutlookTaskGroupCollectionRequest(ContextPath contextPath) {
        super(contextPath, OutlookTaskGroup.class, cp -> new OutlookTaskGroupRequest(cp), SchemaInfo.INSTANCE);
        this.contextPath = contextPath;
    }

    public OutlookTaskFolderCollectionRequest taskFolders() {
        return new OutlookTaskFolderCollectionRequest(contextPath.addSegment("taskFolders"));
    }

    public OutlookTaskFolderRequest taskFolders(String id) {
        return new OutlookTaskFolderRequest(contextPath.addSegment("taskFolders").addKeys(new NameValue(id.toString())));
    }

}
