package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.OutlookTaskFolder;
import odata.msgraph.client.beta.entity.request.MultiValueLegacyExtendedPropertyRequest;
import odata.msgraph.client.beta.entity.request.OutlookTaskFolderRequest;
import odata.msgraph.client.beta.entity.request.OutlookTaskRequest;
import odata.msgraph.client.beta.entity.request.SingleValueLegacyExtendedPropertyRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

public class OutlookTaskFolderCollectionRequest extends CollectionPageEntityRequest<OutlookTaskFolder, OutlookTaskFolderRequest>{

    protected ContextPath contextPath;

    public OutlookTaskFolderCollectionRequest(ContextPath contextPath) {
        super(contextPath, OutlookTaskFolder.class, cp -> new OutlookTaskFolderRequest(cp), SchemaInfo.INSTANCE);
        this.contextPath = contextPath;
    }

    public OutlookTaskCollectionRequest tasks() {
        return new OutlookTaskCollectionRequest(contextPath.addSegment("tasks"));
    }

    public OutlookTaskRequest tasks(String id) {
        return new OutlookTaskRequest(contextPath.addSegment("tasks").addKeys(new NameValue(id.toString())));
    }

    public SingleValueLegacyExtendedPropertyCollectionRequest singleValueExtendedProperties() {
        return new SingleValueLegacyExtendedPropertyCollectionRequest(contextPath.addSegment("singleValueExtendedProperties"));
    }

    public SingleValueLegacyExtendedPropertyRequest singleValueExtendedProperties(String id) {
        return new SingleValueLegacyExtendedPropertyRequest(contextPath.addSegment("singleValueExtendedProperties").addKeys(new NameValue(id.toString())));
    }

    public MultiValueLegacyExtendedPropertyCollectionRequest multiValueExtendedProperties() {
        return new MultiValueLegacyExtendedPropertyCollectionRequest(contextPath.addSegment("multiValueExtendedProperties"));
    }

    public MultiValueLegacyExtendedPropertyRequest multiValueExtendedProperties(String id) {
        return new MultiValueLegacyExtendedPropertyRequest(contextPath.addSegment("multiValueExtendedProperties").addKeys(new NameValue(id.toString())));
    }

}
