package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.OutlookTask;
import odata.msgraph.client.beta.entity.request.AttachmentRequest;
import odata.msgraph.client.beta.entity.request.MultiValueLegacyExtendedPropertyRequest;
import odata.msgraph.client.beta.entity.request.OutlookTaskRequest;
import odata.msgraph.client.beta.entity.request.SingleValueLegacyExtendedPropertyRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

public class OutlookTaskCollectionRequest extends CollectionPageEntityRequest<OutlookTask, OutlookTaskRequest>{

    protected ContextPath contextPath;

    public OutlookTaskCollectionRequest(ContextPath contextPath) {
        super(contextPath, OutlookTask.class, cp -> new OutlookTaskRequest(cp), SchemaInfo.INSTANCE);
        this.contextPath = contextPath;
    }

    public SingleValueLegacyExtendedPropertyCollectionRequest singleValueExtendedProperties() {
        return new SingleValueLegacyExtendedPropertyCollectionRequest(contextPath.addSegment("singleValueExtendedProperties"));
    }

    public SingleValueLegacyExtendedPropertyRequest singleValueExtendedProperties(String id) {
        return new SingleValueLegacyExtendedPropertyRequest(contextPath.addSegment("singleValueExtendedProperties").addKeys(new NameValue(id.toString())));
    }

    public MultiValueLegacyExtendedPropertyCollectionRequest multiValueExtendedProperties() {
        return new MultiValueLegacyExtendedPropertyCollectionRequest(contextPath.addSegment("multiValueExtendedProperties"));
    }

    public MultiValueLegacyExtendedPropertyRequest multiValueExtendedProperties(String id) {
        return new MultiValueLegacyExtendedPropertyRequest(contextPath.addSegment("multiValueExtendedProperties").addKeys(new NameValue(id.toString())));
    }

    public AttachmentCollectionRequest attachments() {
        return new AttachmentCollectionRequest(contextPath.addSegment("attachments"));
    }

    public AttachmentRequest attachments(String id) {
        return new AttachmentRequest(contextPath.addSegment("attachments").addKeys(new NameValue(id.toString())));
    }

}
