package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.Organization;
import odata.msgraph.client.beta.entity.request.CertificateBasedAuthConfigurationRequest;
import odata.msgraph.client.beta.entity.request.ExtensionRequest;
import odata.msgraph.client.beta.entity.request.OrganizationRequest;
import odata.msgraph.client.beta.entity.request.OrganizationalBrandingRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

public class OrganizationCollectionRequest extends CollectionPageEntityRequest<Organization, OrganizationRequest>{

    protected ContextPath contextPath;

    public OrganizationCollectionRequest(ContextPath contextPath) {
        super(contextPath, Organization.class, cp -> new OrganizationRequest(cp), SchemaInfo.INSTANCE);
        this.contextPath = contextPath;
    }

    public OrganizationalBrandingCollectionRequest brandings() {
        return new OrganizationalBrandingCollectionRequest(contextPath.addSegment("brandings"));
    }

    public OrganizationalBrandingRequest brandings(String id) {
        return new OrganizationalBrandingRequest(contextPath.addSegment("brandings").addKeys(new NameValue(id.toString())));
    }

    public CertificateBasedAuthConfigurationCollectionRequest certificateBasedAuthConfiguration() {
        return new CertificateBasedAuthConfigurationCollectionRequest(contextPath.addSegment("certificateBasedAuthConfiguration"));
    }

    public CertificateBasedAuthConfigurationRequest certificateBasedAuthConfiguration(String id) {
        return new CertificateBasedAuthConfigurationRequest(contextPath.addSegment("certificateBasedAuthConfiguration").addKeys(new NameValue(id.toString())));
    }

    public ExtensionCollectionRequest extensions() {
        return new ExtensionCollectionRequest(contextPath.addSegment("extensions"));
    }

    public ExtensionRequest extensions(String id) {
        return new ExtensionRequest(contextPath.addSegment("extensions").addKeys(new NameValue(id.toString())));
    }


}
