package odata.msgraph.client.beta.entity.collection.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.util.Map;

import odata.msgraph.client.beta.entity.OrgContact;
import odata.msgraph.client.beta.entity.request.DirectoryObjectRequest;
import odata.msgraph.client.beta.entity.request.OrgContactRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

public class OrgContactCollectionRequest extends CollectionPageEntityRequest<OrgContact, OrgContactRequest>{

    protected ContextPath contextPath;

    public OrgContactCollectionRequest(ContextPath contextPath) {
        super(contextPath, OrgContact.class, cp -> new OrgContactRequest(cp), SchemaInfo.INSTANCE);
        this.contextPath = contextPath;
    }


    public DirectoryObjectCollectionRequest directReports() {
        return new DirectoryObjectCollectionRequest(contextPath.addSegment("directReports"));
    }

    public DirectoryObjectRequest directReports(String id) {
        return new DirectoryObjectRequest(contextPath.addSegment("directReports").addKeys(new NameValue(id.toString())));
    }

    public DirectoryObjectCollectionRequest memberOf() {
        return new DirectoryObjectCollectionRequest(contextPath.addSegment("memberOf"));
    }

    public DirectoryObjectRequest memberOf(String id) {
        return new DirectoryObjectRequest(contextPath.addSegment("memberOf").addKeys(new NameValue(id.toString())));
    }

    public DirectoryObjectCollectionRequest transitiveMemberOf() {
        return new DirectoryObjectCollectionRequest(contextPath.addSegment("transitiveMemberOf"));
    }

    public DirectoryObjectRequest transitiveMemberOf(String id) {
        return new DirectoryObjectRequest(contextPath.addSegment("transitiveMemberOf").addKeys(new NameValue(id.toString())));
    }

    @Function(name = "delta")
    @JsonIgnore
    public CollectionPageNonEntityRequest<OrgContact> delta() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.delta"), OrgContact.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

}
