package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.OnenoteSection;
import odata.msgraph.client.beta.entity.request.OnenotePageRequest;
import odata.msgraph.client.beta.entity.request.OnenoteSectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

public class OnenoteSectionCollectionRequest extends CollectionPageEntityRequest<OnenoteSection, OnenoteSectionRequest>{

    protected ContextPath contextPath;

    public OnenoteSectionCollectionRequest(ContextPath contextPath) {
        super(contextPath, OnenoteSection.class, cp -> new OnenoteSectionRequest(cp), SchemaInfo.INSTANCE);
        this.contextPath = contextPath;
    }



    public OnenotePageCollectionRequest pages() {
        return new OnenotePageCollectionRequest(contextPath.addSegment("pages"));
    }

    public OnenotePageRequest pages(String id) {
        return new OnenotePageRequest(contextPath.addSegment("pages").addKeys(new NameValue(id.toString())));
    }

}
