package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.OnPremisesPublishingProfile;
import odata.msgraph.client.beta.entity.request.ConnectorGroupRequest;
import odata.msgraph.client.beta.entity.request.ConnectorRequest;
import odata.msgraph.client.beta.entity.request.OnPremisesAgentGroupRequest;
import odata.msgraph.client.beta.entity.request.OnPremisesAgentRequest;
import odata.msgraph.client.beta.entity.request.OnPremisesPublishingProfileRequest;
import odata.msgraph.client.beta.entity.request.PublishedResourceRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

public class OnPremisesPublishingProfileCollectionRequest extends CollectionPageEntityRequest<OnPremisesPublishingProfile, OnPremisesPublishingProfileRequest>{

    protected ContextPath contextPath;

    public OnPremisesPublishingProfileCollectionRequest(ContextPath contextPath) {
        super(contextPath, OnPremisesPublishingProfile.class, cp -> new OnPremisesPublishingProfileRequest(cp), SchemaInfo.INSTANCE);
        this.contextPath = contextPath;
    }

    public OnPremisesAgentCollectionRequest agents() {
        return new OnPremisesAgentCollectionRequest(contextPath.addSegment("agents"));
    }

    public OnPremisesAgentRequest agents(String id) {
        return new OnPremisesAgentRequest(contextPath.addSegment("agents").addKeys(new NameValue(id.toString())));
    }

    public OnPremisesAgentGroupCollectionRequest agentGroups() {
        return new OnPremisesAgentGroupCollectionRequest(contextPath.addSegment("agentGroups"));
    }

    public OnPremisesAgentGroupRequest agentGroups(String id) {
        return new OnPremisesAgentGroupRequest(contextPath.addSegment("agentGroups").addKeys(new NameValue(id.toString())));
    }

    public PublishedResourceCollectionRequest publishedResources() {
        return new PublishedResourceCollectionRequest(contextPath.addSegment("publishedResources"));
    }

    public PublishedResourceRequest publishedResources(String id) {
        return new PublishedResourceRequest(contextPath.addSegment("publishedResources").addKeys(new NameValue(id.toString())));
    }

    public ConnectorCollectionRequest connectors() {
        return new ConnectorCollectionRequest(contextPath.addSegment("connectors"));
    }

    public ConnectorRequest connectors(String id) {
        return new ConnectorRequest(contextPath.addSegment("connectors").addKeys(new NameValue(id.toString())));
    }

    public ConnectorGroupCollectionRequest connectorGroups() {
        return new ConnectorGroupCollectionRequest(contextPath.addSegment("connectorGroups"));
    }

    public ConnectorGroupRequest connectorGroups(String id) {
        return new ConnectorGroupRequest(contextPath.addSegment("connectorGroups").addKeys(new NameValue(id.toString())));
    }

}
