package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.OnPremisesAgentGroup;
import odata.msgraph.client.beta.entity.request.OnPremisesAgentGroupRequest;
import odata.msgraph.client.beta.entity.request.OnPremisesAgentRequest;
import odata.msgraph.client.beta.entity.request.PublishedResourceRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

public class OnPremisesAgentGroupCollectionRequest extends CollectionPageEntityRequest<OnPremisesAgentGroup, OnPremisesAgentGroupRequest>{

    protected ContextPath contextPath;

    public OnPremisesAgentGroupCollectionRequest(ContextPath contextPath) {
        super(contextPath, OnPremisesAgentGroup.class, cp -> new OnPremisesAgentGroupRequest(cp), SchemaInfo.INSTANCE);
        this.contextPath = contextPath;
    }

    public OnPremisesAgentCollectionRequest agents() {
        return new OnPremisesAgentCollectionRequest(contextPath.addSegment("agents"));
    }

    public OnPremisesAgentRequest agents(String id) {
        return new OnPremisesAgentRequest(contextPath.addSegment("agents").addKeys(new NameValue(id.toString())));
    }

    public PublishedResourceCollectionRequest publishedResources() {
        return new PublishedResourceCollectionRequest(contextPath.addSegment("publishedResources"));
    }

    public PublishedResourceRequest publishedResources(String id) {
        return new PublishedResourceRequest(contextPath.addSegment("publishedResources").addKeys(new NameValue(id.toString())));
    }

}
