package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.OnPremisesAgent;
import odata.msgraph.client.beta.entity.request.OnPremisesAgentGroupRequest;
import odata.msgraph.client.beta.entity.request.OnPremisesAgentRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

public class OnPremisesAgentCollectionRequest extends CollectionPageEntityRequest<OnPremisesAgent, OnPremisesAgentRequest>{

    protected ContextPath contextPath;

    public OnPremisesAgentCollectionRequest(ContextPath contextPath) {
        super(contextPath, OnPremisesAgent.class, cp -> new OnPremisesAgentRequest(cp), SchemaInfo.INSTANCE);
        this.contextPath = contextPath;
    }

    public OnPremisesAgentGroupCollectionRequest agentGroups() {
        return new OnPremisesAgentGroupCollectionRequest(contextPath.addSegment("agentGroups"));
    }

    public OnPremisesAgentGroupRequest agentGroups(String id) {
        return new OnPremisesAgentGroupRequest(contextPath.addSegment("agentGroups").addKeys(new NameValue(id.toString())));
    }

}
