package odata.msgraph.client.beta.entity.collection.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.util.Map;

import odata.msgraph.client.beta.entity.OAuth2PermissionGrant;
import odata.msgraph.client.beta.entity.request.OAuth2PermissionGrantRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

public class OAuth2PermissionGrantCollectionRequest extends CollectionPageEntityRequest<OAuth2PermissionGrant, OAuth2PermissionGrantRequest>{

    protected ContextPath contextPath;

    public OAuth2PermissionGrantCollectionRequest(ContextPath contextPath) {
        super(contextPath, OAuth2PermissionGrant.class, cp -> new OAuth2PermissionGrantRequest(cp), SchemaInfo.INSTANCE);
        this.contextPath = contextPath;
    }

    @Function(name = "delta")
    @JsonIgnore
    public CollectionPageNonEntityRequest<OAuth2PermissionGrant> delta() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.delta"), OAuth2PermissionGrant.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

}
