package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.NotificationMessageTemplate;
import odata.msgraph.client.beta.entity.request.LocalizedNotificationMessageRequest;
import odata.msgraph.client.beta.entity.request.NotificationMessageTemplateRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

public class NotificationMessageTemplateCollectionRequest extends CollectionPageEntityRequest<NotificationMessageTemplate, NotificationMessageTemplateRequest>{

    protected ContextPath contextPath;

    public NotificationMessageTemplateCollectionRequest(ContextPath contextPath) {
        super(contextPath, NotificationMessageTemplate.class, cp -> new NotificationMessageTemplateRequest(cp), SchemaInfo.INSTANCE);
        this.contextPath = contextPath;
    }

    public LocalizedNotificationMessageCollectionRequest localizedNotificationMessages() {
        return new LocalizedNotificationMessageCollectionRequest(contextPath.addSegment("localizedNotificationMessages"));
    }

    public LocalizedNotificationMessageRequest localizedNotificationMessages(String id) {
        return new LocalizedNotificationMessageRequest(contextPath.addSegment("localizedNotificationMessages").addKeys(new NameValue(id.toString())));
    }

}
