package odata.msgraph.client.beta.entity.collection.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.util.Map;

import odata.msgraph.client.beta.complex.CopyNotebookModel;
import odata.msgraph.client.beta.complex.RecentNotebook;
import odata.msgraph.client.beta.entity.Notebook;
import odata.msgraph.client.beta.entity.request.NotebookRequest;
import odata.msgraph.client.beta.entity.request.OnenoteSectionRequest;
import odata.msgraph.client.beta.entity.request.SectionGroupRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

public class NotebookCollectionRequest extends CollectionPageEntityRequest<Notebook, NotebookRequest>{

    protected ContextPath contextPath;

    public NotebookCollectionRequest(ContextPath contextPath) {
        super(contextPath, Notebook.class, cp -> new NotebookRequest(cp), SchemaInfo.INSTANCE);
        this.contextPath = contextPath;
    }

    public OnenoteSectionCollectionRequest sections() {
        return new OnenoteSectionCollectionRequest(contextPath.addSegment("sections"));
    }

    public OnenoteSectionRequest sections(String id) {
        return new OnenoteSectionRequest(contextPath.addSegment("sections").addKeys(new NameValue(id.toString())));
    }

    public SectionGroupCollectionRequest sectionGroups() {
        return new SectionGroupCollectionRequest(contextPath.addSegment("sectionGroups"));
    }

    public SectionGroupRequest sectionGroups(String id) {
        return new SectionGroupRequest(contextPath.addSegment("sectionGroups").addKeys(new NameValue(id.toString())));
    }

    @Action(name = "getNotebookFromWebUrl")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<CopyNotebookModel> getNotebookFromWebUrl(String webUrl) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("webUrl", "Edm.String", Checks.checkIsAscii(webUrl))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<CopyNotebookModel>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getNotebookFromWebUrl"), CopyNotebookModel.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "getRecentNotebooks")
    @JsonIgnore
    public CollectionPageNonEntityRequest<RecentNotebook> getRecentNotebooks(Boolean includePersonalNotebooks) {
        Preconditions.checkNotNull(includePersonalNotebooks, "includePersonalNotebooks cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("includePersonalNotebooks", "Edm.Boolean", includePersonalNotebooks)
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getRecentNotebooks"), RecentNotebook.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

}
