package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.MobileAppTroubleshootingEvent;
import odata.msgraph.client.beta.entity.request.AppLogCollectionRequestRequest;
import odata.msgraph.client.beta.entity.request.MobileAppTroubleshootingEventRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

public class MobileAppTroubleshootingEventCollectionRequest extends CollectionPageEntityRequest<MobileAppTroubleshootingEvent, MobileAppTroubleshootingEventRequest>{

    protected ContextPath contextPath;

    public MobileAppTroubleshootingEventCollectionRequest(ContextPath contextPath) {
        super(contextPath, MobileAppTroubleshootingEvent.class, cp -> new MobileAppTroubleshootingEventRequest(cp), SchemaInfo.INSTANCE);
        this.contextPath = contextPath;
    }

    public AppLogCollectionRequestCollectionRequest appLogCollectionRequests() {
        return new AppLogCollectionRequestCollectionRequest(contextPath.addSegment("appLogCollectionRequests"));
    }

    public AppLogCollectionRequestRequest appLogCollectionRequests(String id) {
        return new AppLogCollectionRequestRequest(contextPath.addSegment("appLogCollectionRequests").addKeys(new NameValue(id.toString())));
    }

}
