package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.MobileAppContent;
import odata.msgraph.client.beta.entity.request.MobileAppContentFileRequest;
import odata.msgraph.client.beta.entity.request.MobileAppContentRequest;
import odata.msgraph.client.beta.entity.request.MobileContainedAppRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

public class MobileAppContentCollectionRequest extends CollectionPageEntityRequest<MobileAppContent, MobileAppContentRequest>{

    protected ContextPath contextPath;

    public MobileAppContentCollectionRequest(ContextPath contextPath) {
        super(contextPath, MobileAppContent.class, cp -> new MobileAppContentRequest(cp), SchemaInfo.INSTANCE);
        this.contextPath = contextPath;
    }

    public MobileAppContentFileCollectionRequest files() {
        return new MobileAppContentFileCollectionRequest(contextPath.addSegment("files"));
    }

    public MobileAppContentFileRequest files(String id) {
        return new MobileAppContentFileRequest(contextPath.addSegment("files").addKeys(new NameValue(id.toString())));
    }

    public MobileContainedAppCollectionRequest containedApps() {
        return new MobileContainedAppCollectionRequest(contextPath.addSegment("containedApps"));
    }

    public MobileContainedAppRequest containedApps(String id) {
        return new MobileContainedAppRequest(contextPath.addSegment("containedApps").addKeys(new NameValue(id.toString())));
    }

}
