package odata.msgraph.client.beta.entity.collection.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.util.List;
import java.util.Map;

import odata.msgraph.client.beta.complex.HasPayloadLinkResultItem;
import odata.msgraph.client.beta.entity.MdmWindowsInformationProtectionPolicy;
import odata.msgraph.client.beta.entity.request.MdmWindowsInformationProtectionPolicyRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

public class MdmWindowsInformationProtectionPolicyCollectionRequest extends CollectionPageEntityRequest<MdmWindowsInformationProtectionPolicy, MdmWindowsInformationProtectionPolicyRequest>{

    protected ContextPath contextPath;

    public MdmWindowsInformationProtectionPolicyCollectionRequest(ContextPath contextPath) {
        super(contextPath, MdmWindowsInformationProtectionPolicy.class, cp -> new MdmWindowsInformationProtectionPolicyRequest(cp), SchemaInfo.INSTANCE);
        this.contextPath = contextPath;
    }

    @Action(name = "hasPayloadLinks")
    @JsonIgnore
    public CollectionPageNonEntityRequest<HasPayloadLinkResultItem> hasPayloadLinks(List<String> payloadIds) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("payloadIds", "Collection(Edm.String)", Checks.checkIsAscii(payloadIds))
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.hasPayloadLinks"), HasPayloadLinkResultItem.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

}
