package odata.msgraph.client.beta.entity.collection.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.util.Map;

import odata.msgraph.client.beta.entity.ManagementCondition;
import odata.msgraph.client.beta.entity.request.ManagementConditionRequest;
import odata.msgraph.client.beta.entity.request.ManagementConditionStatementRequest;
import odata.msgraph.client.beta.enums.DevicePlatformType;
import odata.msgraph.client.beta.schema.SchemaInfo;

public class ManagementConditionCollectionRequest extends CollectionPageEntityRequest<ManagementCondition, ManagementConditionRequest>{

    protected ContextPath contextPath;

    public ManagementConditionCollectionRequest(ContextPath contextPath) {
        super(contextPath, ManagementCondition.class, cp -> new ManagementConditionRequest(cp), SchemaInfo.INSTANCE);
        this.contextPath = contextPath;
    }

    public ManagementConditionStatementCollectionRequest managementConditionStatements() {
        return new ManagementConditionStatementCollectionRequest(contextPath.addSegment("managementConditionStatements"));
    }

    public ManagementConditionStatementRequest managementConditionStatements(String id) {
        return new ManagementConditionStatementRequest(contextPath.addSegment("managementConditionStatements").addKeys(new NameValue(id.toString())));
    }

    @Function(name = "getManagementConditionsForPlatform")
    @JsonIgnore
    public CollectionPageNonEntityRequest<ManagementCondition> getManagementConditionsForPlatform(DevicePlatformType platform) {
        Preconditions.checkNotNull(platform, "platform cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("platform", "microsoft.graph.devicePlatformType", platform)
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getManagementConditionsForPlatform"), ManagementCondition.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

}
