package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.ManagedEBook;
import odata.msgraph.client.beta.entity.request.DeviceInstallStateRequest;
import odata.msgraph.client.beta.entity.request.ManagedEBookAssignmentRequest;
import odata.msgraph.client.beta.entity.request.ManagedEBookCategoryRequest;
import odata.msgraph.client.beta.entity.request.ManagedEBookRequest;
import odata.msgraph.client.beta.entity.request.UserInstallStateSummaryRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

public class ManagedEBookCollectionRequest extends CollectionPageEntityRequest<ManagedEBook, ManagedEBookRequest>{

    protected ContextPath contextPath;

    public ManagedEBookCollectionRequest(ContextPath contextPath) {
        super(contextPath, ManagedEBook.class, cp -> new ManagedEBookRequest(cp), SchemaInfo.INSTANCE);
        this.contextPath = contextPath;
    }

    public ManagedEBookCategoryCollectionRequest categories() {
        return new ManagedEBookCategoryCollectionRequest(contextPath.addSegment("categories"));
    }

    public ManagedEBookCategoryRequest categories(String id) {
        return new ManagedEBookCategoryRequest(contextPath.addSegment("categories").addKeys(new NameValue(id.toString())));
    }

    public ManagedEBookAssignmentCollectionRequest assignments() {
        return new ManagedEBookAssignmentCollectionRequest(contextPath.addSegment("assignments"));
    }

    public ManagedEBookAssignmentRequest assignments(String id) {
        return new ManagedEBookAssignmentRequest(contextPath.addSegment("assignments").addKeys(new NameValue(id.toString())));
    }


    public DeviceInstallStateCollectionRequest deviceStates() {
        return new DeviceInstallStateCollectionRequest(contextPath.addSegment("deviceStates"));
    }

    public DeviceInstallStateRequest deviceStates(String id) {
        return new DeviceInstallStateRequest(contextPath.addSegment("deviceStates").addKeys(new NameValue(id.toString())));
    }

    public UserInstallStateSummaryCollectionRequest userStateSummary() {
        return new UserInstallStateSummaryCollectionRequest(contextPath.addSegment("userStateSummary"));
    }

    public UserInstallStateSummaryRequest userStateSummary(String id) {
        return new UserInstallStateSummaryRequest(contextPath.addSegment("userStateSummary").addKeys(new NameValue(id.toString())));
    }

}
