package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.ManagedDeviceMobileAppConfiguration;
import odata.msgraph.client.beta.entity.request.ManagedDeviceMobileAppConfigurationAssignmentRequest;
import odata.msgraph.client.beta.entity.request.ManagedDeviceMobileAppConfigurationDeviceStatusRequest;
import odata.msgraph.client.beta.entity.request.ManagedDeviceMobileAppConfigurationRequest;
import odata.msgraph.client.beta.entity.request.ManagedDeviceMobileAppConfigurationUserStatusRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

public class ManagedDeviceMobileAppConfigurationCollectionRequest extends CollectionPageEntityRequest<ManagedDeviceMobileAppConfiguration, ManagedDeviceMobileAppConfigurationRequest>{

    protected ContextPath contextPath;

    public ManagedDeviceMobileAppConfigurationCollectionRequest(ContextPath contextPath) {
        super(contextPath, ManagedDeviceMobileAppConfiguration.class, cp -> new ManagedDeviceMobileAppConfigurationRequest(cp), SchemaInfo.INSTANCE);
        this.contextPath = contextPath;
    }

    public ManagedDeviceMobileAppConfigurationAssignmentCollectionRequest assignments() {
        return new ManagedDeviceMobileAppConfigurationAssignmentCollectionRequest(contextPath.addSegment("assignments"));
    }

    public ManagedDeviceMobileAppConfigurationAssignmentRequest assignments(String id) {
        return new ManagedDeviceMobileAppConfigurationAssignmentRequest(contextPath.addSegment("assignments").addKeys(new NameValue(id.toString())));
    }

    public ManagedDeviceMobileAppConfigurationDeviceStatusCollectionRequest deviceStatuses() {
        return new ManagedDeviceMobileAppConfigurationDeviceStatusCollectionRequest(contextPath.addSegment("deviceStatuses"));
    }

    public ManagedDeviceMobileAppConfigurationDeviceStatusRequest deviceStatuses(String id) {
        return new ManagedDeviceMobileAppConfigurationDeviceStatusRequest(contextPath.addSegment("deviceStatuses").addKeys(new NameValue(id.toString())));
    }

    public ManagedDeviceMobileAppConfigurationUserStatusCollectionRequest userStatuses() {
        return new ManagedDeviceMobileAppConfigurationUserStatusCollectionRequest(contextPath.addSegment("userStatuses"));
    }

    public ManagedDeviceMobileAppConfigurationUserStatusRequest userStatuses(String id) {
        return new ManagedDeviceMobileAppConfigurationUserStatusRequest(contextPath.addSegment("userStatuses").addKeys(new NameValue(id.toString())));
    }



}
