package odata.msgraph.client.beta.entity.collection.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.util.List;
import java.util.Map;

import odata.msgraph.client.beta.complex.BulkManagedDeviceActionResult;
import odata.msgraph.client.beta.entity.ManagedDevice;
import odata.msgraph.client.beta.entity.request.DetectedAppRequest;
import odata.msgraph.client.beta.entity.request.DeviceCompliancePolicyStateRequest;
import odata.msgraph.client.beta.entity.request.DeviceConfigurationStateRequest;
import odata.msgraph.client.beta.entity.request.DeviceLogCollectionResponseRequest;
import odata.msgraph.client.beta.entity.request.ManagedDeviceMobileAppConfigurationStateRequest;
import odata.msgraph.client.beta.entity.request.ManagedDeviceRequest;
import odata.msgraph.client.beta.entity.request.SecurityBaselineStateRequest;
import odata.msgraph.client.beta.entity.request.UserRequest;
import odata.msgraph.client.beta.enums.ManagedDeviceRemoteAction;
import odata.msgraph.client.beta.schema.SchemaInfo;

public class ManagedDeviceCollectionRequest extends CollectionPageEntityRequest<ManagedDevice, ManagedDeviceRequest>{

    protected ContextPath contextPath;

    public ManagedDeviceCollectionRequest(ContextPath contextPath) {
        super(contextPath, ManagedDevice.class, cp -> new ManagedDeviceRequest(cp), SchemaInfo.INSTANCE);
        this.contextPath = contextPath;
    }

    public SecurityBaselineStateCollectionRequest securityBaselineStates() {
        return new SecurityBaselineStateCollectionRequest(contextPath.addSegment("securityBaselineStates"));
    }

    public SecurityBaselineStateRequest securityBaselineStates(String id) {
        return new SecurityBaselineStateRequest(contextPath.addSegment("securityBaselineStates").addKeys(new NameValue(id.toString())));
    }

    public DeviceConfigurationStateCollectionRequest deviceConfigurationStates() {
        return new DeviceConfigurationStateCollectionRequest(contextPath.addSegment("deviceConfigurationStates"));
    }

    public DeviceConfigurationStateRequest deviceConfigurationStates(String id) {
        return new DeviceConfigurationStateRequest(contextPath.addSegment("deviceConfigurationStates").addKeys(new NameValue(id.toString())));
    }

    public DeviceCompliancePolicyStateCollectionRequest deviceCompliancePolicyStates() {
        return new DeviceCompliancePolicyStateCollectionRequest(contextPath.addSegment("deviceCompliancePolicyStates"));
    }

    public DeviceCompliancePolicyStateRequest deviceCompliancePolicyStates(String id) {
        return new DeviceCompliancePolicyStateRequest(contextPath.addSegment("deviceCompliancePolicyStates").addKeys(new NameValue(id.toString())));
    }

    public ManagedDeviceMobileAppConfigurationStateCollectionRequest managedDeviceMobileAppConfigurationStates() {
        return new ManagedDeviceMobileAppConfigurationStateCollectionRequest(contextPath.addSegment("managedDeviceMobileAppConfigurationStates"));
    }

    public ManagedDeviceMobileAppConfigurationStateRequest managedDeviceMobileAppConfigurationStates(String id) {
        return new ManagedDeviceMobileAppConfigurationStateRequest(contextPath.addSegment("managedDeviceMobileAppConfigurationStates").addKeys(new NameValue(id.toString())));
    }

    public DetectedAppCollectionRequest detectedApps() {
        return new DetectedAppCollectionRequest(contextPath.addSegment("detectedApps"));
    }

    public DetectedAppRequest detectedApps(String id) {
        return new DetectedAppRequest(contextPath.addSegment("detectedApps").addKeys(new NameValue(id.toString())));
    }



    public UserCollectionRequest users() {
        return new UserCollectionRequest(contextPath.addSegment("users"));
    }

    public UserRequest users(String id) {
        return new UserRequest(contextPath.addSegment("users").addKeys(new NameValue(id.toString())));
    }

    public DeviceLogCollectionResponseCollectionRequest logCollectionRequests() {
        return new DeviceLogCollectionResponseCollectionRequest(contextPath.addSegment("logCollectionRequests"));
    }

    public DeviceLogCollectionResponseRequest logCollectionRequests(String id) {
        return new DeviceLogCollectionResponseRequest(contextPath.addSegment("logCollectionRequests").addKeys(new NameValue(id.toString())));
    }

    @Action(name = "executeAction")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<BulkManagedDeviceActionResult> executeAction(ManagedDeviceRemoteAction actionName, Boolean keepEnrollmentData, Boolean keepUserData, List<String> deviceIds, String notificationTitle, String notificationBody, String deviceName) {
        Preconditions.checkNotNull(actionName, "actionName cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("actionName", "microsoft.graph.managedDeviceRemoteAction", actionName)
            .put("keepEnrollmentData", "Edm.Boolean", keepEnrollmentData)
            .put("keepUserData", "Edm.Boolean", keepUserData)
            .put("deviceIds", "Collection(Edm.String)", Checks.checkIsAscii(deviceIds))
            .put("notificationTitle", "Edm.String", Checks.checkIsAscii(notificationTitle))
            .put("notificationBody", "Edm.String", Checks.checkIsAscii(notificationBody))
            .put("deviceName", "Edm.String", Checks.checkIsAscii(deviceName))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<BulkManagedDeviceActionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.executeAction"), BulkManagedDeviceActionResult.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

}
