package odata.msgraph.client.beta.entity.collection.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.util.Map;

import odata.msgraph.client.beta.entity.ManagedAppRegistration;
import odata.msgraph.client.beta.entity.request.ManagedAppOperationRequest;
import odata.msgraph.client.beta.entity.request.ManagedAppPolicyRequest;
import odata.msgraph.client.beta.entity.request.ManagedAppRegistrationRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

public class ManagedAppRegistrationCollectionRequest extends CollectionPageEntityRequest<ManagedAppRegistration, ManagedAppRegistrationRequest>{

    protected ContextPath contextPath;

    public ManagedAppRegistrationCollectionRequest(ContextPath contextPath) {
        super(contextPath, ManagedAppRegistration.class, cp -> new ManagedAppRegistrationRequest(cp), SchemaInfo.INSTANCE);
        this.contextPath = contextPath;
    }

    public ManagedAppPolicyCollectionRequest appliedPolicies() {
        return new ManagedAppPolicyCollectionRequest(contextPath.addSegment("appliedPolicies"));
    }

    public ManagedAppPolicyRequest appliedPolicies(String id) {
        return new ManagedAppPolicyRequest(contextPath.addSegment("appliedPolicies").addKeys(new NameValue(id.toString())));
    }

    public ManagedAppPolicyCollectionRequest intendedPolicies() {
        return new ManagedAppPolicyCollectionRequest(contextPath.addSegment("intendedPolicies"));
    }

    public ManagedAppPolicyRequest intendedPolicies(String id) {
        return new ManagedAppPolicyRequest(contextPath.addSegment("intendedPolicies").addKeys(new NameValue(id.toString())));
    }

    public ManagedAppOperationCollectionRequest operations() {
        return new ManagedAppOperationCollectionRequest(contextPath.addSegment("operations"));
    }

    public ManagedAppOperationRequest operations(String id) {
        return new ManagedAppOperationRequest(contextPath.addSegment("operations").addKeys(new NameValue(id.toString())));
    }

    @Function(name = "getUserIdsWithFlaggedAppRegistration")
    @JsonIgnore
    public CollectionPageNonEntityRequest<String> getUserIdsWithFlaggedAppRegistration() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getUserIdsWithFlaggedAppRegistration"), String.class, _parameters, com.github.davidmoten.odata.client.internal.EdmSchemaInfo.INSTANCE);
    }

}
