package odata.msgraph.client.beta.entity.collection.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.util.Map;

import odata.msgraph.client.beta.entity.MailFolder;
import odata.msgraph.client.beta.entity.request.MailFolderRequest;
import odata.msgraph.client.beta.entity.request.MessageRequest;
import odata.msgraph.client.beta.entity.request.MessageRuleRequest;
import odata.msgraph.client.beta.entity.request.MultiValueLegacyExtendedPropertyRequest;
import odata.msgraph.client.beta.entity.request.SingleValueLegacyExtendedPropertyRequest;
import odata.msgraph.client.beta.entity.request.UserConfigurationRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

public class MailFolderCollectionRequest extends CollectionPageEntityRequest<MailFolder, MailFolderRequest>{

    protected ContextPath contextPath;

    public MailFolderCollectionRequest(ContextPath contextPath) {
        super(contextPath, MailFolder.class, cp -> new MailFolderRequest(cp), SchemaInfo.INSTANCE);
        this.contextPath = contextPath;
    }

    public SingleValueLegacyExtendedPropertyCollectionRequest singleValueExtendedProperties() {
        return new SingleValueLegacyExtendedPropertyCollectionRequest(contextPath.addSegment("singleValueExtendedProperties"));
    }

    public SingleValueLegacyExtendedPropertyRequest singleValueExtendedProperties(String id) {
        return new SingleValueLegacyExtendedPropertyRequest(contextPath.addSegment("singleValueExtendedProperties").addKeys(new NameValue(id.toString())));
    }

    public MultiValueLegacyExtendedPropertyCollectionRequest multiValueExtendedProperties() {
        return new MultiValueLegacyExtendedPropertyCollectionRequest(contextPath.addSegment("multiValueExtendedProperties"));
    }

    public MultiValueLegacyExtendedPropertyRequest multiValueExtendedProperties(String id) {
        return new MultiValueLegacyExtendedPropertyRequest(contextPath.addSegment("multiValueExtendedProperties").addKeys(new NameValue(id.toString())));
    }

    public MessageCollectionRequest messages() {
        return new MessageCollectionRequest(contextPath.addSegment("messages"));
    }

    public MessageRequest messages(String id) {
        return new MessageRequest(contextPath.addSegment("messages").addKeys(new NameValue(id.toString())));
    }

    public MessageRuleCollectionRequest messageRules() {
        return new MessageRuleCollectionRequest(contextPath.addSegment("messageRules"));
    }

    public MessageRuleRequest messageRules(String id) {
        return new MessageRuleRequest(contextPath.addSegment("messageRules").addKeys(new NameValue(id.toString())));
    }

    public MailFolderCollectionRequest childFolders() {
        return new MailFolderCollectionRequest(contextPath.addSegment("childFolders"));
    }

    public MailFolderRequest childFolders(String id) {
        return new MailFolderRequest(contextPath.addSegment("childFolders").addKeys(new NameValue(id.toString())));
    }

    public UserConfigurationCollectionRequest userConfigurations() {
        return new UserConfigurationCollectionRequest(contextPath.addSegment("userConfigurations"));
    }

    public UserConfigurationRequest userConfigurations(String id) {
        return new UserConfigurationRequest(contextPath.addSegment("userConfigurations").addKeys(new NameValue(id.toString())));
    }

    @Function(name = "delta")
    @JsonIgnore
    public CollectionPageNonEntityRequest<MailFolder> delta() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.delta"), MailFolder.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

}
