package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.ListItem;
import odata.msgraph.client.beta.entity.request.ItemActivityOLDRequest;
import odata.msgraph.client.beta.entity.request.ListItemRequest;
import odata.msgraph.client.beta.entity.request.ListItemVersionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

public class ListItemCollectionRequest extends CollectionPageEntityRequest<ListItem, ListItemRequest>{

    protected ContextPath contextPath;

    public ListItemCollectionRequest(ContextPath contextPath) {
        super(contextPath, ListItem.class, cp -> new ListItemRequest(cp), SchemaInfo.INSTANCE);
        this.contextPath = contextPath;
    }

    public ItemActivityOLDCollectionRequest activities() {
        return new ItemActivityOLDCollectionRequest(contextPath.addSegment("activities"));
    }

    public ItemActivityOLDRequest activities(String id) {
        return new ItemActivityOLDRequest(contextPath.addSegment("activities").addKeys(new NameValue(id.toString())));
    }




    public ListItemVersionCollectionRequest versions() {
        return new ListItemVersionCollectionRequest(contextPath.addSegment("versions"));
    }

    public ListItemVersionRequest versions(String id) {
        return new ListItemVersionRequest(contextPath.addSegment("versions").addKeys(new NameValue(id.toString())));
    }

}
