package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.List;
import odata.msgraph.client.beta.entity.request.ColumnDefinitionRequest;
import odata.msgraph.client.beta.entity.request.ContentTypeRequest;
import odata.msgraph.client.beta.entity.request.ItemActivityOLDRequest;
import odata.msgraph.client.beta.entity.request.ListItemRequest;
import odata.msgraph.client.beta.entity.request.ListRequest;
import odata.msgraph.client.beta.entity.request.SubscriptionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

public class ListCollectionRequest extends CollectionPageEntityRequest<List, ListRequest>{

    protected ContextPath contextPath;

    public ListCollectionRequest(ContextPath contextPath) {
        super(contextPath, List.class, cp -> new ListRequest(cp), SchemaInfo.INSTANCE);
        this.contextPath = contextPath;
    }

    public ItemActivityOLDCollectionRequest activities() {
        return new ItemActivityOLDCollectionRequest(contextPath.addSegment("activities"));
    }

    public ItemActivityOLDRequest activities(String id) {
        return new ItemActivityOLDRequest(contextPath.addSegment("activities").addKeys(new NameValue(id.toString())));
    }

    public ColumnDefinitionCollectionRequest columns() {
        return new ColumnDefinitionCollectionRequest(contextPath.addSegment("columns"));
    }

    public ColumnDefinitionRequest columns(String id) {
        return new ColumnDefinitionRequest(contextPath.addSegment("columns").addKeys(new NameValue(id.toString())));
    }

    public ContentTypeCollectionRequest contentTypes() {
        return new ContentTypeCollectionRequest(contextPath.addSegment("contentTypes"));
    }

    public ContentTypeRequest contentTypes(String id) {
        return new ContentTypeRequest(contextPath.addSegment("contentTypes").addKeys(new NameValue(id.toString())));
    }


    public ListItemCollectionRequest items() {
        return new ListItemCollectionRequest(contextPath.addSegment("items"));
    }

    public ListItemRequest items(String id) {
        return new ListItemRequest(contextPath.addSegment("items").addKeys(new NameValue(id.toString())));
    }

    public SubscriptionCollectionRequest subscriptions() {
        return new SubscriptionCollectionRequest(contextPath.addSegment("subscriptions"));
    }

    public SubscriptionRequest subscriptions(String id) {
        return new SubscriptionRequest(contextPath.addSegment("subscriptions").addKeys(new NameValue(id.toString())));
    }

}
