package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.Journal;
import odata.msgraph.client.beta.entity.request.JournalLineRequest;
import odata.msgraph.client.beta.entity.request.JournalRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

public class JournalCollectionRequest extends CollectionPageEntityRequest<Journal, JournalRequest>{

    protected ContextPath contextPath;

    public JournalCollectionRequest(ContextPath contextPath) {
        super(contextPath, Journal.class, cp -> new JournalRequest(cp), SchemaInfo.INSTANCE);
        this.contextPath = contextPath;
    }


    public JournalLineCollectionRequest journalLines() {
        return new JournalLineCollectionRequest(contextPath.addSegment("journalLines"));
    }

    public JournalLineRequest journalLines(String id) {
        return new JournalLineRequest(contextPath.addSegment("journalLines").addKeys(new NameValue(id.toString())));
    }

}
