package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.Item;
import odata.msgraph.client.beta.entity.request.ItemRequest;
import odata.msgraph.client.beta.entity.request.PictureRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

public class ItemCollectionRequest extends CollectionPageEntityRequest<Item, ItemRequest>{

    protected ContextPath contextPath;

    public ItemCollectionRequest(ContextPath contextPath) {
        super(contextPath, Item.class, cp -> new ItemRequest(cp), SchemaInfo.INSTANCE);
        this.contextPath = contextPath;
    }

    public PictureCollectionRequest picture() {
        return new PictureCollectionRequest(contextPath.addSegment("picture"));
    }

    public PictureRequest picture(String id) {
        return new PictureRequest(contextPath.addSegment("picture").addKeys(new NameValue(id.toString())));
    }


}
