package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.ItemActivityStat;
import odata.msgraph.client.beta.entity.request.ItemActivityRequest;
import odata.msgraph.client.beta.entity.request.ItemActivityStatRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

public class ItemActivityStatCollectionRequest extends CollectionPageEntityRequest<ItemActivityStat, ItemActivityStatRequest>{

    protected ContextPath contextPath;

    public ItemActivityStatCollectionRequest(ContextPath contextPath) {
        super(contextPath, ItemActivityStat.class, cp -> new ItemActivityStatRequest(cp), SchemaInfo.INSTANCE);
        this.contextPath = contextPath;
    }

    public ItemActivityCollectionRequest activities() {
        return new ItemActivityCollectionRequest(contextPath.addSegment("activities"));
    }

    public ItemActivityRequest activities(String id) {
        return new ItemActivityRequest(contextPath.addSegment("activities").addKeys(new NameValue(id.toString())));
    }

}
