package odata.msgraph.client.beta.entity.collection.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.util.List;
import java.util.Map;

import odata.msgraph.client.beta.complex.HasPayloadLinkResultItem;
import odata.msgraph.client.beta.entity.IosManagedAppProtection;
import odata.msgraph.client.beta.entity.request.IosManagedAppProtectionRequest;
import odata.msgraph.client.beta.entity.request.ManagedMobileAppRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

public class IosManagedAppProtectionCollectionRequest extends CollectionPageEntityRequest<IosManagedAppProtection, IosManagedAppProtectionRequest>{

    protected ContextPath contextPath;

    public IosManagedAppProtectionCollectionRequest(ContextPath contextPath) {
        super(contextPath, IosManagedAppProtection.class, cp -> new IosManagedAppProtectionRequest(cp), SchemaInfo.INSTANCE);
        this.contextPath = contextPath;
    }

    public ManagedMobileAppCollectionRequest apps() {
        return new ManagedMobileAppCollectionRequest(contextPath.addSegment("apps"));
    }

    public ManagedMobileAppRequest apps(String id) {
        return new ManagedMobileAppRequest(contextPath.addSegment("apps").addKeys(new NameValue(id.toString())));
    }


    @Action(name = "hasPayloadLinks")
    @JsonIgnore
    public CollectionPageNonEntityRequest<HasPayloadLinkResultItem> hasPayloadLinks(List<String> payloadIds) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("payloadIds", "Collection(Edm.String)", Checks.checkIsAscii(payloadIds))
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.hasPayloadLinks"), HasPayloadLinkResultItem.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

}
