package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.IntuneBrandingProfile;
import odata.msgraph.client.beta.entity.request.IntuneBrandingProfileAssignmentRequest;
import odata.msgraph.client.beta.entity.request.IntuneBrandingProfileRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

public class IntuneBrandingProfileCollectionRequest extends CollectionPageEntityRequest<IntuneBrandingProfile, IntuneBrandingProfileRequest>{

    protected ContextPath contextPath;

    public IntuneBrandingProfileCollectionRequest(ContextPath contextPath) {
        super(contextPath, IntuneBrandingProfile.class, cp -> new IntuneBrandingProfileRequest(cp), SchemaInfo.INSTANCE);
        this.contextPath = contextPath;
    }

    public IntuneBrandingProfileAssignmentCollectionRequest assignments() {
        return new IntuneBrandingProfileAssignmentCollectionRequest(contextPath.addSegment("assignments"));
    }

    public IntuneBrandingProfileAssignmentRequest assignments(String id) {
        return new IntuneBrandingProfileAssignmentRequest(contextPath.addSegment("assignments").addKeys(new NameValue(id.toString())));
    }

}
