package odata.msgraph.client.beta.entity.collection.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.util.List;
import java.util.Map;

import odata.msgraph.client.beta.entity.ImportedWindowsAutopilotDeviceIdentity;
import odata.msgraph.client.beta.entity.request.ImportedWindowsAutopilotDeviceIdentityRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

public class ImportedWindowsAutopilotDeviceIdentityCollectionRequest extends CollectionPageEntityRequest<ImportedWindowsAutopilotDeviceIdentity, ImportedWindowsAutopilotDeviceIdentityRequest>{

    protected ContextPath contextPath;

    public ImportedWindowsAutopilotDeviceIdentityCollectionRequest(ContextPath contextPath) {
        super(contextPath, ImportedWindowsAutopilotDeviceIdentity.class, cp -> new ImportedWindowsAutopilotDeviceIdentityRequest(cp), SchemaInfo.INSTANCE);
        this.contextPath = contextPath;
    }

    @Action(name = "import")
    @JsonIgnore
    public CollectionPageNonEntityRequest<ImportedWindowsAutopilotDeviceIdentity> import_(List<ImportedWindowsAutopilotDeviceIdentity> importedWindowsAutopilotDeviceIdentities) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("importedWindowsAutopilotDeviceIdentities", "Collection(microsoft.graph.importedWindowsAutopilotDeviceIdentity)", importedWindowsAutopilotDeviceIdentities)
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.import"), ImportedWindowsAutopilotDeviceIdentity.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

}
