package odata.msgraph.client.beta.entity.collection.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.util.List;
import java.util.Map;

import odata.msgraph.client.beta.entity.ImportedDeviceIdentity;
import odata.msgraph.client.beta.entity.ImportedDeviceIdentityResult;
import odata.msgraph.client.beta.entity.request.ImportedDeviceIdentityRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

public class ImportedDeviceIdentityCollectionRequest extends CollectionPageEntityRequest<ImportedDeviceIdentity, ImportedDeviceIdentityRequest>{

    protected ContextPath contextPath;

    public ImportedDeviceIdentityCollectionRequest(ContextPath contextPath) {
        super(contextPath, ImportedDeviceIdentity.class, cp -> new ImportedDeviceIdentityRequest(cp), SchemaInfo.INSTANCE);
        this.contextPath = contextPath;
    }

    @Action(name = "importDeviceIdentityList")
    @JsonIgnore
    public CollectionPageNonEntityRequest<ImportedDeviceIdentityResult> importDeviceIdentityList(List<ImportedDeviceIdentity> importedDeviceIdentities, Boolean overwriteImportedDeviceIdentities) {
        Preconditions.checkNotNull(overwriteImportedDeviceIdentities, "overwriteImportedDeviceIdentities cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("importedDeviceIdentities", "Collection(microsoft.graph.importedDeviceIdentity)", importedDeviceIdentities)
            .put("overwriteImportedDeviceIdentities", "Edm.Boolean", overwriteImportedDeviceIdentities)
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.importDeviceIdentityList"), ImportedDeviceIdentityResult.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Action(name = "searchExistingIdentities")
    @JsonIgnore
    public CollectionPageNonEntityRequest<ImportedDeviceIdentity> searchExistingIdentities(List<ImportedDeviceIdentity> importedDeviceIdentities) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("importedDeviceIdentities", "Collection(microsoft.graph.importedDeviceIdentity)", importedDeviceIdentities)
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.searchExistingIdentities"), ImportedDeviceIdentity.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

}
