package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.GroupPolicyUploadedDefinitionFile;
import odata.msgraph.client.beta.entity.request.GroupPolicyOperationRequest;
import odata.msgraph.client.beta.entity.request.GroupPolicyUploadedDefinitionFileRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

public class GroupPolicyUploadedDefinitionFileCollectionRequest extends CollectionPageEntityRequest<GroupPolicyUploadedDefinitionFile, GroupPolicyUploadedDefinitionFileRequest>{

    protected ContextPath contextPath;

    public GroupPolicyUploadedDefinitionFileCollectionRequest(ContextPath contextPath) {
        super(contextPath, GroupPolicyUploadedDefinitionFile.class, cp -> new GroupPolicyUploadedDefinitionFileRequest(cp), SchemaInfo.INSTANCE);
        this.contextPath = contextPath;
    }

    public GroupPolicyOperationCollectionRequest groupPolicyOperations() {
        return new GroupPolicyOperationCollectionRequest(contextPath.addSegment("groupPolicyOperations"));
    }

    public GroupPolicyOperationRequest groupPolicyOperations(String id) {
        return new GroupPolicyOperationRequest(contextPath.addSegment("groupPolicyOperations").addKeys(new NameValue(id.toString())));
    }

}
