package odata.msgraph.client.beta.entity.collection.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollection;
import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.util.Map;

import odata.msgraph.client.beta.entity.GroupPolicyMigrationReport;
import odata.msgraph.client.beta.entity.GroupPolicyObjectFile;
import odata.msgraph.client.beta.entity.request.GroupPolicyMigrationReportRequest;
import odata.msgraph.client.beta.entity.request.GroupPolicySettingMappingRequest;
import odata.msgraph.client.beta.entity.request.UnsupportedGroupPolicyExtensionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

public class GroupPolicyMigrationReportCollectionRequest extends CollectionPageEntityRequest<GroupPolicyMigrationReport, GroupPolicyMigrationReportRequest>{

    protected ContextPath contextPath;

    public GroupPolicyMigrationReportCollectionRequest(ContextPath contextPath) {
        super(contextPath, GroupPolicyMigrationReport.class, cp -> new GroupPolicyMigrationReportRequest(cp), SchemaInfo.INSTANCE);
        this.contextPath = contextPath;
    }

    public GroupPolicySettingMappingCollectionRequest groupPolicySettingMappings() {
        return new GroupPolicySettingMappingCollectionRequest(contextPath.addSegment("groupPolicySettingMappings"));
    }

    public GroupPolicySettingMappingRequest groupPolicySettingMappings(String id) {
        return new GroupPolicySettingMappingRequest(contextPath.addSegment("groupPolicySettingMappings").addKeys(new NameValue(id.toString())));
    }

    public UnsupportedGroupPolicyExtensionCollectionRequest unsupportedGroupPolicyExtensions() {
        return new UnsupportedGroupPolicyExtensionCollectionRequest(contextPath.addSegment("unsupportedGroupPolicyExtensions"));
    }

    public UnsupportedGroupPolicyExtensionRequest unsupportedGroupPolicyExtensions(String id) {
        return new UnsupportedGroupPolicyExtensionRequest(contextPath.addSegment("unsupportedGroupPolicyExtensions").addKeys(new NameValue(id.toString())));
    }

    @Action(name = "createMigrationReport")
    @JsonIgnore
    public ActionRequestReturningNonCollection<String> createMigrationReport(GroupPolicyObjectFile groupPolicyObjectFile) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("groupPolicyObjectFile", "microsoft.graph.groupPolicyObjectFile", groupPolicyObjectFile)
            .build();
        return new ActionRequestReturningNonCollection<String>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.createMigrationReport"), String.class, _parameters, com.github.davidmoten.odata.client.internal.EdmSchemaInfo.INSTANCE);
    }

}
