package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.GroupPolicyDefinitionValue;
import odata.msgraph.client.beta.entity.request.GroupPolicyDefinitionValueRequest;
import odata.msgraph.client.beta.entity.request.GroupPolicyPresentationValueRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

public class GroupPolicyDefinitionValueCollectionRequest extends CollectionPageEntityRequest<GroupPolicyDefinitionValue, GroupPolicyDefinitionValueRequest>{

    protected ContextPath contextPath;

    public GroupPolicyDefinitionValueCollectionRequest(ContextPath contextPath) {
        super(contextPath, GroupPolicyDefinitionValue.class, cp -> new GroupPolicyDefinitionValueRequest(cp), SchemaInfo.INSTANCE);
        this.contextPath = contextPath;
    }

    public GroupPolicyPresentationValueCollectionRequest presentationValues() {
        return new GroupPolicyPresentationValueCollectionRequest(contextPath.addSegment("presentationValues"));
    }

    public GroupPolicyPresentationValueRequest presentationValues(String id) {
        return new GroupPolicyPresentationValueRequest(contextPath.addSegment("presentationValues").addKeys(new NameValue(id.toString())));
    }


}
