package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.GroupPolicyDefinitionFile;
import odata.msgraph.client.beta.entity.request.GroupPolicyDefinitionFileRequest;
import odata.msgraph.client.beta.entity.request.GroupPolicyDefinitionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

public class GroupPolicyDefinitionFileCollectionRequest extends CollectionPageEntityRequest<GroupPolicyDefinitionFile, GroupPolicyDefinitionFileRequest>{

    protected ContextPath contextPath;

    public GroupPolicyDefinitionFileCollectionRequest(ContextPath contextPath) {
        super(contextPath, GroupPolicyDefinitionFile.class, cp -> new GroupPolicyDefinitionFileRequest(cp), SchemaInfo.INSTANCE);
        this.contextPath = contextPath;
    }

    public GroupPolicyDefinitionCollectionRequest definitions() {
        return new GroupPolicyDefinitionCollectionRequest(contextPath.addSegment("definitions"));
    }

    public GroupPolicyDefinitionRequest definitions(String id) {
        return new GroupPolicyDefinitionRequest(contextPath.addSegment("definitions").addKeys(new NameValue(id.toString())));
    }

}
