package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.GroupPolicyDefinition;
import odata.msgraph.client.beta.entity.request.GroupPolicyDefinitionRequest;
import odata.msgraph.client.beta.entity.request.GroupPolicyPresentationRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

public class GroupPolicyDefinitionCollectionRequest extends CollectionPageEntityRequest<GroupPolicyDefinition, GroupPolicyDefinitionRequest>{

    protected ContextPath contextPath;

    public GroupPolicyDefinitionCollectionRequest(ContextPath contextPath) {
        super(contextPath, GroupPolicyDefinition.class, cp -> new GroupPolicyDefinitionRequest(cp), SchemaInfo.INSTANCE);
        this.contextPath = contextPath;
    }



    public GroupPolicyPresentationCollectionRequest presentations() {
        return new GroupPolicyPresentationCollectionRequest(contextPath.addSegment("presentations"));
    }

    public GroupPolicyPresentationRequest presentations(String id) {
        return new GroupPolicyPresentationRequest(contextPath.addSegment("presentations").addKeys(new NameValue(id.toString())));
    }

}
