package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.GroupPolicyConfiguration;
import odata.msgraph.client.beta.entity.request.GroupPolicyConfigurationAssignmentRequest;
import odata.msgraph.client.beta.entity.request.GroupPolicyConfigurationRequest;
import odata.msgraph.client.beta.entity.request.GroupPolicyDefinitionValueRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

public class GroupPolicyConfigurationCollectionRequest extends CollectionPageEntityRequest<GroupPolicyConfiguration, GroupPolicyConfigurationRequest>{

    protected ContextPath contextPath;

    public GroupPolicyConfigurationCollectionRequest(ContextPath contextPath) {
        super(contextPath, GroupPolicyConfiguration.class, cp -> new GroupPolicyConfigurationRequest(cp), SchemaInfo.INSTANCE);
        this.contextPath = contextPath;
    }

    public GroupPolicyDefinitionValueCollectionRequest definitionValues() {
        return new GroupPolicyDefinitionValueCollectionRequest(contextPath.addSegment("definitionValues"));
    }

    public GroupPolicyDefinitionValueRequest definitionValues(String id) {
        return new GroupPolicyDefinitionValueRequest(contextPath.addSegment("definitionValues").addKeys(new NameValue(id.toString())));
    }

    public GroupPolicyConfigurationAssignmentCollectionRequest assignments() {
        return new GroupPolicyConfigurationAssignmentCollectionRequest(contextPath.addSegment("assignments"));
    }

    public GroupPolicyConfigurationAssignmentRequest assignments(String id) {
        return new GroupPolicyConfigurationAssignmentRequest(contextPath.addSegment("assignments").addKeys(new NameValue(id.toString())));
    }

}
