package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.GroupPolicyCategory;
import odata.msgraph.client.beta.entity.request.GroupPolicyCategoryRequest;
import odata.msgraph.client.beta.entity.request.GroupPolicyDefinitionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

public class GroupPolicyCategoryCollectionRequest extends CollectionPageEntityRequest<GroupPolicyCategory, GroupPolicyCategoryRequest>{

    protected ContextPath contextPath;

    public GroupPolicyCategoryCollectionRequest(ContextPath contextPath) {
        super(contextPath, GroupPolicyCategory.class, cp -> new GroupPolicyCategoryRequest(cp), SchemaInfo.INSTANCE);
        this.contextPath = contextPath;
    }


    public GroupPolicyCategoryCollectionRequest children() {
        return new GroupPolicyCategoryCollectionRequest(contextPath.addSegment("children"));
    }

    public GroupPolicyCategoryRequest children(String id) {
        return new GroupPolicyCategoryRequest(contextPath.addSegment("children").addKeys(new NameValue(id.toString())));
    }

    public GroupPolicyDefinitionCollectionRequest definitions() {
        return new GroupPolicyDefinitionCollectionRequest(contextPath.addSegment("definitions"));
    }

    public GroupPolicyDefinitionRequest definitions(String id) {
        return new GroupPolicyDefinitionRequest(contextPath.addSegment("definitions").addKeys(new NameValue(id.toString())));
    }


}
